<id>
Notify Plus
</id>

<version>
3.0beta - SP1.31
</version>

<mod info>
New for version 3.0
- Updated and re-written for SP1.31

Bugfixes in version 2.2.1:
- Name and email are now shown in the notification-email 
- Forgotten '$' in NotifyPlus.pl is fixed 
- document.notify.submit() works with all browsers now (thx to Lauren Ward) 
- Now also Guests can trigger the autosend Mailinglist 
- Working dutch.lng 
- Some cosmetic updates 
- Problem solved with showing Guest-notifications 
- Removed "set cencored words"-problem solved


What does this mod do ?

Replaces the standard Notification option:
- Receive the reply-text in your mailbox, not only a notification !
- Choose Plain Text or HTML to receive your 'Notification of replies' in.
- When you choose for HTML, the email (almost) looks like your Forum-post !
- A reply-button (to reply on the topic) appears in your mailbox (only works for not hidden boards)
- The notification view (that shows all your notifications), also shows the format (HTML/Plain).
- Members can set their 'Notification of replies'-format in their Profile.
- Extra format-type defined: HTML-Attached, gives you a plain text message with the HTML-file attached.
- Possibility to enable 'mark' notified threads (with an image) in the Admin Center.

Adds a Notification on Boardlevel to your Forum:
- This option can be enabled in the Admin Center.
- Possibility to enable 'mark' notified boards (with an image) in the Admin Center.

Adds the possibility for Guest-Notification:
- Possibility to enable notification for guests in the Admin Center.
- The notification view (that shows all your notifications), is also possible for guests.
- Admin can see what guest have what Notifications on

Adds a Mailinglist to your Forum:
- This option can be enabled in the Admin Center.
- A member can simply (un)subscribe in his/her Profile (check the boards that appear on the Mailinglist).
- Choose Plain Text or HTML to receive your Mailinglist in.
- Admin has the possibility in the Admin Center, to view/delete the members on the Mailinglist.
- Admin has the possibility in the Admin Center, to send the Mailinglist.

Adds an autosend Mailinglist option to your Forum:
- You can choose between autosend the Mailinglist or send a reminder email
- Autosend Frequency can be never, daily, weekly or monthly
- The email-address where the email reminder is sent to can be set

Adds the possibility to include images in you email:
- This option can be enabled in the Profile.
- The email will be larger (because the images are included), but the images will also be visible when you are offline !!

Installation:
- Install the mod using BoardMod
- Copy NotifyPlus.pl to the Sources directory
- Copy Lite.pm to the Sources directory
- Copy mark_icon.gif to the Images directory
- Change the variables in 'Forum Preferences and Settings' & Profile
- Two extra Language updates are available: Dutch & German

Known problems:
On some servers MIME::Types and MAIL::address are not installed.

To solve this problem you have to:
1) Set the next parameter to 1 in Lite.pm:
### Set this true if you don't want to use MIME::Base64/QuotedPrint/Types:
$PARANOID = 0;
2) Install address.pm in your YaBB source-directory (included in the zip-file !!)
3) Change a line in the Lite.pm:
Line 509
if (eval "require Mail::Address") {

Change to:
if (eval "require Sources::address") {

</mod info>

<author>
Sonic
</author>

<homepage>
http://www.scotsonphones.co.uk/YaBB
</homepage>

<edit file>
YaBB.pl
</edit file>

<search for>
require "$sourcedir/Security.pl";
</search for>

<add after>
# --- Added for Notify Plus 3.0 --- #
require "$sourcedir/NotifyPlus.pl";
# --- /Added for Notify Plus 3.0 --- #
</add after>

<search for>
&LoadIMs;		# Load IM's
</search for>

<add after>
# --- Added for Notify Plus 3.0 --- #
&Autosend;		# Autosend Mailinglist/Email Reminder
# --- /Added for Notify Plus 3.0 --- #

</add after>

<edit file>
english.lng
</edit file>

<search for>
$txt{'800'} = "Other";
</search for>

<add after>
# --- Added for Notify Plus 3.0 --- #
$notify_txt{'1'} = "Send notification in format:";
$notify_txt{'2'} = "HTML";
$notify_txt{'3'} = "Plain text";
$notify_txt{'4'} = "Hi,";
$notify_txt{'5'} = "Somebody replied to the topic your are monitoring !";
$notify_txt{'6'} = "Click here";
$notify_txt{'7'} = "to view the topic";
$notify_txt{'8'} = "Reply from";
$notify_txt{'9'} = "on:";
$notify_txt{'10'} = "Reply";
$notify_txt{'11'} = "Regards,";
$notify_txt{'12'} = "The $mbname team.";
$notify_txt{'13'} = "Enable Email Notification for guests?";
$notify_txt{'14'} = "Please enter your email address:";
$notify_txt{'15'} = "Ok";
$notify_txt{'16'} = "You can not use this email-address, is being used by a registered member already!";
$notify_txt{'17'} = "The images within a HTML-message (not HTML-Attached!!) are also visible when reading email offline (makes the message bigger !)";
$notify_txt{'18'} = "Enable Mailinglist?";
$notify_txt{'19'} = "Notification & Mailinglist";
$notify_txt{'20'} = "View members on the Mailinglist";
$notify_txt{'21'} = "Send the Mailinglist-email";
$notify_txt{'22'} = "Send Mailinglist-email in format:";
$notify_txt{'23'} = "This is the format you will receive your Mailinglist-email in.";
$notify_txt{'24'} = "Boards included in Mailinglist-email:";
$notify_txt{'25'} = "New posts on checked Boards will appear in your Mailinglist-email";
$notify_txt{'26'} = "Members on the Mailinglist";
$notify_txt{'27'} = "Email";
$notify_txt{'28'} = "Format";
$notify_txt{'29'} = "Boards";
$notify_txt{'30'} = "Delete";
$notify_txt{'31'} = "Here you can enter some text that will be printed before the Mailinglist-items. Remember when using HTML, some members receive the Mailinglist in Plain Text !!<br>You can use the [member]-tag and [date]-tag in subject and/or text. [member] will be replaced by the membername and [date] by the actual date.";$notify_txt{'32'} = "Send the Mailinglist !";
$notify_txt{'33'} = "Last sent on:";
$notify_txt{'34'} = "There are no new posts on one of the boards, you checked in your profile, to appear in your Mailinglist-email !";
$notify_txt{'35'} = "Subject";
$notify_txt{'36'} = "Enable Email Notification on Board-level?";
$notify_txt{'37'} = "Enable 'mark' notified boards?";
$notify_txt{'38'} = "Enable 'mark' notified threads?";
$notify_txt{'39'} = "Include images in HTML-message?";
$notify_txt{'40'} = "Would you like to deactivate Notification on this board\?";
$notify_txt{'41'} = "Do you want a notification e-mail if someone posts in this board\?";
$notify_txt{'42'} = "There are no boards with Notification marked!";
$notify_txt{'43'} = "You are notified on posts in the following boards:";
$notify_txt{'44'} = "Activate checkboxes to <b><i>deactivate</i></b> Notification on Board/Topic!";
$notify_txt{'45'} = "HTML-Attached";
$notify_txt{'46'} = "Type of HTML-message:";
$notify_txt{'47'} = "This is the type of HTML-message you want to receive when you choose for HTML within YaBB.<br>'HTML' is a normal HTML-message e.a. used in Outlook.<br>'HTML-Attached' is a plain text message with a HTML-file as attachment.";
$notify_txt{'48'} = "Images Directory";
$notify_txt{'49'} = "Somebody posted a topic in a board your are monitoring !";
$notify_txt{'50'} = "Autosend";
$notify_txt{'51'} = "Mailinglist";
$notify_txt{'52'} = "Email Reminder";
$notify_txt{'53'} = "Frequency";
$notify_txt{'54'} = "Never";
$notify_txt{'55'} = "Daily";
$notify_txt{'56'} = "Weekly";
$notify_txt{'57'} = "Email Reminder address";
$notify_txt{'58'} = "Mailinglist";
$notify_txt{'59'} = "Mailinglist Reminder";
$notify_txt{'60'} = "You have to send out the mailinglist again !";
$notify_txt{'61'} = "Monthly";
$notify_txt{'62'} = "Show Guest Notifications";
$notify_txt{'63'} = "Notifications for email-address: ";
$notify_txt{'64'} = "Reply with quote";
# --- /Added for Notify Plus 3.0 --- #

</add after>

<edit file>
Sources/Admin.pl
</edit file>

<search for>
        - <a href="$cgi;action=setcensor">$txt{'135'}</a>
</search for>

<replace>
<!--- Deleted for Notify Plus 3.0 --->
<!---   - <a href="$cgi;action=setcensor">$txt{'135'}</a> --->
<!--- Deleted for Notify Plus 3.0 --->

<!--- Added for Notify Plus 3.0 --->
~;
	# Only show when Guestnotification is on
	if ($enable_notification_guest) {
		$yymain .= qq~
        - <a href="$cgi;action=setcensor">$txt{'135'}</a><br>
        - <a href="$cgi;action=showguestnotify">$notify_txt{'62'}</a>
~;
	}
	else {
		$yymain .= qq~
        - <a href="$cgi;action=setcensor">$txt{'135'}</a>
~;
	}

$yymain .= qq~
<!--- /Added for Notify Plus 3.0 --->

</replace>

<search for>
	unlink("$memberdir/$currentmem.imconfig");
</search for>

<add after>
# --- Added for Notify Plus 3.0 --- #
	unlink("$memberdir/$currentmem.da2");

	# Delete Member from Mailinglist
	if ($enable_mailinglist == 1) {

		# Read Mailinglist File
		fopen(FILE, "$vardir/mailinglist.txt");
		@mailinglist = <FILE>;
		fclose (FILE);

		# Open file again to update !
		fopen(FILE, ">$vardir/mailinglist.txt");

		# -----------------------------------------------------------------------------
		# Read the mailinglist File
		# -----------------------------------------------------------------------------
		foreach $line (@mailinglist) {

			chomp($line);
			local($user, $email, $format, $oldsubscribed) = split(/\|/, $line);

			# Write Member when not deleted
			if ($user ne $currentmem) {
				print FILE "$line\n";
			}
		}

		# Close file
		fclose (FILE);
	}
# --- /Added for Notify Plus 3.0 --- #

</add after>

<search for>
    </table><BR>
    <table border="0" cellpadding="4" cellspacing="1" bgcolor="$color{'bordercolor'}" class="bordercolor" width="100%">
      <tr>
        <td bgcolor="$color{'catbg'}" height="19" class="catbg"><img src="$imagesdir/board.gif" alt="" border="0"> <font size="2"><b>$txt{'501'}</b></font></td>
      </tr><tr>
</search for>

<add before>
<!--- Added for Notify Plus 3.0 --->
~;
if ($enable_mailinglist == 1) {

	# Open default Mailinglist Text
	fopen(FILE, "$vardir/mailtext.txt");
	@mailtext = <FILE>;
	fclose(FILE);

	# Get date
	($dummy1, $dummy2, $dummy3, $ml_date) = split(/\|/, @mailtext[0]);
	chomp($ml_date);
	&timeformat($ml_date,0);
	$newml_date = $newformat;

$yymain .= qq~
    </table><BR>
    <table border="0" cellpadding="4" cellspacing="1" bgcolor="$color{'bordercolor'}" class="bordercolor" width="100%">

      <tr>
        <td bgcolor="$color{'catbg'}" height="19" class="catbg"><img src="$imagesdir/board.gif" alt="" border="0"> <font size="2"><b>$notify_txt{'58'}</b></font></td>
      </tr><tr>
        <td bgcolor="$color{'windowbg2'}" class="windowbg2"><font size="1">
        <font size="1">$notify_txt{'33'} $newml_date</font><br>
        - <a href="$cgi;action=viewmailinglist">$notify_txt{'20'}</a><br>
        - <a href="$cgi;action=sendmailinglist">$notify_txt{'21'}</a><br>
        </font></td>

      </tr>
~;
}

$yymain .= qq~
<!--- /Added for Notify Plus 3.0 --->

</add before>

<edit file>
Sources/AdminEdit.pl
</edit file>

<search for>
$admineditplver = "1 Gold - SP 1.3.1";
</search for>

<add after>
# --- Added for Notify Plus 3.0 --- #
require "$sourcedir/NotifyPlus.pl";
# --- /Added for Notify Plus 3.0 --- #

</add after>

<search for>
	if ($enable_notification) { $notifchecked = "checked" }
</search for>

<add after>
# --- Added for Notify Plus 3.0 --- #
	if ($enable_notification_board) { $notifyboardchecked = "checked" }
	if ($enable_mark_board) { $markboardchecked = "checked" }
	if ($enable_mark_thread) { $markthreadchecked = "checked" }
	if ($enable_notification_guest) { $notifyguestchecked = "checked" }
	if ($enable_mailinglist) { $mailinglistchecked = "checked" }
	if ($autosend eq "") { $autosend = "EmailReminder" }
	if ($autosend_frequency eq "") { $autosend_frequency = "Never" }
# --- /Added for Notify Plus 3.0 --- #

</add after>

<search for>
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$txt{'392'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=text name="LOCK_EX" size="5" value="$LOCK_EX"></td>
</search for>

<add before>
<!--- Added for Notify Plus 3.0 --->
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$notify_txt{'48'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=text name="imagesurl" size="35" value="$imagesurl"></td>
 </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$notify_txt{'36'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=checkbox name="enable_notification_board" $notifyboardchecked></td>
 </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$notify_txt{'37'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=checkbox name="enable_mark_board" $markboardchecked></td>
 </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$notify_txt{'38'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=checkbox name="enable_mark_thread" $markthreadchecked></td>
 </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$notify_txt{'13'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=checkbox name="enable_notification_guest" $notifyguestchecked></td>
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$notify_txt{'18'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=checkbox name="enable_mailinglist" $mailinglistchecked></td>
 </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$notify_txt{'50'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}">
~;
	# Autosend Mailinglist 
	if ($autosend eq "Mailinglist") {
		$yymain .= qq~ 
	<input type="radio" name="autosend" value="Mailinglist" checked><font size="2">&nbsp;$notify_txt{'51'}</font>
	<input type="radio" name="autosend" value="EmailReminder"><font size="2">&nbsp;$notify_txt{'52'}</font>
~;
	}
	# Autosend Email Reminder
	else {
		$yymain .= qq~ 
	<input type="radio" name="autosend" value="Mailinglist"><font size="2">&nbsp;$notify_txt{'51'}</font>
	<input type="radio" name="autosend" value="EmailReminder" checked><font size="2">&nbsp;$notify_txt{'52'}</font>
~;
	}

	$yymain .= qq~
</tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$notify_txt{'53'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}">
~;

	# Autosend Frequency: Never
	if ($autosend_frequency eq "Never") {
		$yymain .= qq~ 
	<input type="radio" name="autosend_frequency" value="Never" checked><font size="2">&nbsp;$notify_txt{'54'}</font>
	<input type="radio" name="autosend_frequency" value="Daily"><font size="2">&nbsp;$notify_txt{'55'}</font>
	<input type="radio" name="autosend_frequency" value="Weekly"><font size="2">&nbsp;$notify_txt{'56'}</font>
	<input type="radio" name="autosend_frequency" value="Monthly"><font size="2">&nbsp;$notify_txt{'61'}</font>
~;
	}

	# Autosend Frequency: Daily
	elsif ($autosend_frequency eq "Daily") {
		$yymain .= qq~ 
	<input type="radio" name="autosend_frequency" value="Never"><font size="2">&nbsp;$notify_txt{'54'}</font>
	<input type="radio" name="autosend_frequency" value="Daily" checked><font size="2">&nbsp;$notify_txt{'55'}</font>
	<input type="radio" name="autosend_frequency" value="Weekly"><font size="2">&nbsp;$notify_txt{'56'}</font>
	<input type="radio" name="autosend_frequency" value="Monthly"><font size="2">&nbsp;$notify_txt{'61'}</font>
~;
	}

	# Autosend Frequency: Weekly
	elsif ($autosend_frequency eq "Weekly") {
		$yymain .= qq~ 
	<input type="radio" name="autosend_frequency" value="Never"><font size="2">&nbsp;$notify_txt{'54'}</font>
	<input type="radio" name="autosend_frequency" value="Daily"><font size="2">&nbsp;$notify_txt{'55'}</font>
	<input type="radio" name="autosend_frequency" value="Weekly" checked><font size="2">&nbsp;$notify_txt{'56'}</font>
	<input type="radio" name="autosend_frequency" value="Monthly"><font size="2">&nbsp;$notify_txt{'61'}</font>
~;
	}

	# Autosend Frequency: Weekly
	elsif ($autosend_frequency eq "Monthly") {
		$yymain .= qq~ 
	<input type="radio" name="autosend_frequency" value="Never"><font size="2">&nbsp;$notify_txt{'54'}</font>
	<input type="radio" name="autosend_frequency" value="Daily"><font size="2">&nbsp;$notify_txt{'55'}</font>
	<input type="radio" name="autosend_frequency" value="Weekly"><font size="2">&nbsp;$notify_txt{'56'}</font>
	<input type="radio" name="autosend_frequency" value="Monthly checked"><font size="2">&nbsp;$notify_txt{'61'}</font>
~;
	}

	$yymain .= qq~
  </tr><tr>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><font size="2">$notify_txt{'57'}</font></td>
    <td class="windowbg2" bgcolor="$color{'windowbg2'}"><input type=text name="email_reminder_address" size="35" value="$email_reminder_address"></td>
 </tr><tr>
    <td colspan="2" class="windowbg2" bgcolor="$color{'windowbg2'}"><hr size=1 width="100%" color="$color{'windowbg3'}" class="windowbg3"></td>

<!--- /Added for Notify Plus 3.0 --->

</add before>

<search for>
	my @onoff = qw/
		allowpics showyabbcbutt showbdescrip maintenance guestaccess insert_original enable_ubbc enable_news enable_guestposting enable_notification showlatestmember showrecentbar showmarkread showmodify showuserpic showusertext showgenderimage shownewsfader MenuType curposlinks profilebutton autolinkurls emailpassword RegAgree emailwelcome allow_hide_email usetempfile faketruncation emailnewpass/;
</search for>

<add after>
# --- Added for Notify Plus 3.0 --- #
	push(@onoff, "enable_notification_board");
	push(@onoff, "enable_mark_board");
	push(@onoff, "enable_mark_thread");
	push(@onoff, "enable_notification_guest");
	push(@onoff, "enable_mailinglist");
# --- /Added for Notify Plus 3.0 --- #

</add after>

<search for>
	$imagesdir = $FORM{'imagesdir'} || "$boardurl/YaBBImages";
</search for>

<add after>
# --- Added for Notify Plus 3.0 --- #
	$imagesurl = $FORM{'imagesurl'} || "$boarddir/YaBBImages";
	$autosend = $FORM{'autosend'};
	$autosend_frequency = $FORM{'autosend_frequency'};
	$email_reminder_address = $FORM{'email_reminder_address'};
# --- /Added for Notify Plus 3.0 --- #

</add after>

<search for>
########## File Locking ##########
</search for>

<add before>
# --- Added for Notify Plus 3.0 --- #

########## Notify Plus ##########

\$imagesurl = "$imagesurl";						# Directory of your images (Still an Error in original YaBB SP1 !!!)
\$enable_notification_board = $enable_notification_board;	# Allow e-mail notification on Board-level
\$enable_mark_board = $enable_mark_board;				# Enable mark of Boards
\$enable_mark_thread = $enable_mark_thread;			# Enable mark of Threads
\$enable_notification_guest = $enable_notification_guest;	# Allow e-mail notification for guests
\$enable_mailinglist = $enable_mailinglist;			# Allow use of Mailinglist
\$autosend = "$autosend";						# Autosend the Mailinglist or Email Reminder
\$autosend_frequency = "$autosend_frequency";			# Autosend frequency (Never, Daily, Weekly)	
\$email_reminder_address = q^$email_reminder_address^;	# Email Reminder Address
# --- /Added for Notify Plus 3.0 --- #

</add before>

<edit file>
Sources/BoardIndex.pl
</edit file>

<search for>
      </tr>~;
		foreach $curboard (@{$catboards{$curcat}}) {
			chomp $curboard;
</search for>

<add after>
# --- Added for Notify Plus 3.0 --- #

			# Reset Mark-image
			$markimg = "";

			# Is mark board enabled and it's a Member ?
			if ($enable_mark_board == 1 && $username ne 'Guest') {

				# Has the member a notification on this board ?!
				if (fopen(FILE, "$boardsdir/$curboard.mail")) {

					# Read all records

					fopen(FILE, "$boardsdir/$curboard.mail");
					@mails = <FILE>;
					fclose(FILE);
					foreach $record (@mails) {

						chomp($record);
						($email, $format) = split(/\|/, $record);
						chomp($email);

						# Yep, Notification found
						if ($email eq $settings[2]) {
							$markimg  = qq~<img src='$imagesdir/mark_icon.gif' border='0'>~;
							last;
						}

					# End Foreach
					}


				# End if Has the member a notification
				}

			# End if Is mark board enabled
			}

# --- /Added for Notify Plus 3.0 --- #

</add after>

<search for>
        <font size="2"><a name="$curboard" href="$scripturl?board=$curboard"><b>$curboardname</b></a></font>
</search for>

<replace>
<!--- Deleted for Notify Plus 3.0 --->
<!---                    <font size="2"><a name="$curboard" href="$scripturl?board=$curboard"><b>$curboardname</b></a></font> --->
<!--- /Deleted for Notify Plus 3.0 --->

<!--- Added for Notify Plus 3.0 --->
        $markimg         <font size="2"><a name="$curboard" href="$scripturl?board=$curboard"><b>$curboardname</b></a></font>
<!--- /Added for Notify Plus 3.0 --->

</replace>

<edit file>
Sources/ManageBoards.pl
</edit file>

<search for>
$manageboardsplver = "1 Gold - SP 1.3";
</search for>

<add after>
# --- Added for Notify Plus 3.0 --- #
require "$sourcedir/NotifyPlus.pl";
# --- /Added for Notify Plus 3.0 --- #

</add after>

<search for>
			&Sticky_remove($id);
</search for>

<add after>
# --- Added for Notify Plus 3.0 --- #
			&RemoveThread_Mailinglist($id);
# --- /Added for Notify Plus 3.0 --- #

</add after>

<search for>
		unlink("$boardsdir/$curboard.ctb");
</search for>

<add after>
# --- Added for Notify Plus 3.0 --- #
		&RemoveBoard_Mailinglist($curboard);
# --- /Added for Notify Plus 3.0 --- #

</add after>

<edit file>
Sources/ManageCats.pl
</edit file>

<search for>
$managecatsplver = "1 Gold - SP 1.3";
</search for>

<add after>
# --- Added for Notify Plus 3.0 --- #
require "$sourcedir/NotifyPlus.pl";
# --- /Added for Notify Plus 3.0 --- #

</add after>

<search for>
					unlink("$datadir/$id.mail");
</search for>

<add after>
# --- Added for Notify Plus 3.0 --- #
			&RemoveThread_Mailinglist($id);
# --- /Added for Notify Plus 3.0 --- #

</add after>

<search for>
			unlink("$boardsdir/$curboard.dat");
</search for>

<add after>
# --- Added for Notify Plus 3.0 --- #
			&RemoveBoard_Mailinglist($curboard);
# --- /Added for Notify Plus 3.0 --- #

</add after>

<edit file>
Sources/MessageIndex.pl
</edit file>

<search for>
if($showmarkread) {
	$yymain .= qq~<a href="$cgi;action=markasread">$img{'markboardread'}</a>~;
}
</search for>

<add after>
# --- Added for Notify Plus 3.0 --- #

# Notification on Board-level is enabled ?
if($enable_notification_board == 1) {
	$yymain .= qq~$menusep<a href="$cgi;action=notifyboard">$img{'notify'}</a>~;
}
# --- /Added for Notify Plus 3.0 --- #

</add after>

<search for>
	if($showmarkread) { $yymain .= qq~<a href="$cgi;action=markasread">$img{'markboardread'}</a>~; }
</search for>

<add after>
# --- Added for Notify Plus 3.0 --- #

	# Notification on Board-level is enabled ?
	if($enable_notification_board == 1) {
		$yymain .= qq~$menusep<a href="$cgi;action=notifyboard">$img{'notify'}</a>~;
	}
# --- /Added for Notify Plus 3.0 --- #

</add after>

<search for>
	foreach( @threads ) {
		($mnum, $msub, $mname, $memail, $mdate, $mreplies, $musername, $micon, $mstate) = split( /\|/, $_ );
</search for>

<add after>
# --- Added for Notify Plus 3.0 --- #

		# Reset Mark-image
		$markimg = "";

		# Is mark thread enabled and it's a Member ?
		if ($enable_mark_thread == 1 && $username ne 'Guest') {

			# Has the member a notification on this thread ?!
			if (fopen(FILE, "$datadir/$mnum.mail")) {

				# Read all records
				fopen(FILE, "$datadir/$mnum.mail");
				@mails = <FILE>;
				fclose(FILE);
				foreach $record (@mails) {

					chomp($record);
					($email, $format) = split(/\|/, $record);
					chomp($email);

					# Yep, Notification found
					if ($email eq $settings[2]) {
						$markimg  = qq~<img src='$imagesdir/mark_icon.gif' border='0'>~;
						last;
					}

				# End Foreach
				}

			# End if Has the member a notification
			}

		# End if Is mark thread enabled
		}

# --- /Added for Notify Plus 3.0 --- #

</add after>

<search for>
        <td class="windowbg" valign="middle" width="44%" bgcolor="$color{'windowbg'}"><font size="2">$new <a href="$cgi;action=display;num=$mnum"><b>$msub</b></a> $pages</font></td>
</search for>

<replace>
<!--- Deleted for Notify Plus 3.0 --->
<!--- 	                <td class="windowbg" valign="middle" width="44%" bgcolor="$color{'windowbg'}"><font size="2">$new <a href="$cgi;action=display;num=$mnum"><b>$msub</b></a> $pages</font></td>
<!--- /Deleted for Notify Plus 3.0 --->

<!--- Added for Notify Plus 3.0 --->
        <td class="windowbg" valign="middle" width="44%" bgcolor="$color{'windowbg'}"><font size=2>$new  $markimg <a href="$cgi;action=display;num=$mnum"><b>$msub</b></a> $pages</font></td>
<!--- /Added for Notify Plus 3.0 --->

</replace>

<edit file>
Sources/Notify.pl
</edit file>

<search for>
$notifyplver = "1 Gold - SP 1.3";
</search for>

<replace>
$notifyplver = "1 Gold - SP 1.3 - Plus v3.0";

# --- Added for Notify Plus 3.0 --- #
require "$sourcedir/NotifyPlus.pl";
# --- /Added for Notify Plus 3.0 --- #

</replace>

<search for>
sub Notify {
	if( $currentboard eq '' ) { &fatal_error($txt{'1'}); }
	if($username eq "Guest") { &fatal_error("$txt{'138'}"); }
</search for>

<replace>
# --- Deleted for Notify Plus 3.0 --- #
#sub Notify {
#	if( $currentboard eq '' ) { &fatal_error($txt{'1'}); }
#	if($username eq "Guest") { &fatal_error("$txt{'138'}"); }
# --- /Deleted for Notify Plus 3.0 --- #

# --- Added for Notify Plus 3.0 --- #
sub Notify {
	if( $currentboard eq '' ) { &fatal_error($txt{'1'}); }
	if($username eq 'Guest' && $enable_notification_guest == 0) { &fatal_error("$txt{'138'}"); }

	# When email of Guest not entered yet ...
	if($username eq "Guest") {

		if ($FORM{'guest_email'} eq "") {

			$yymain .= qq~
			<table border=0 width=100% cellspacing=1 bgcolor="$color{'bordercolor'}" class="bordercolor">
			<tr>
			    <td class="titlebg" bgcolor="$color{'titlebg'}">
					<font size=2 class="text1" color="$color{'titletext'}"><b>$txt{'125'}</b></font>
				</td>
			</tr>
			<tr>
		    	<td class="windowbg" bgcolor="$color{'windowbg'}">
					<font size=2>
					<form action="$cgi;action=notify;thread=$INFO{'thread'};start=$INFO{'start'}" method="post" name="notifyForm">
						$notify_txt{'14'}
						<input type="text" name="guest_email" size="25" maxlength="30">
						<br>
						<b><a href="javascript:document.notifyForm.submit();">$notify_txt{'15'}</a> - <a href="javascript:history.go(-1)">$txt{'250'}</a></b>
					</form>
			    	</font>
				</td>
			</tr>
			</table>
~;

			$yytitle = "$txt{'125'}";
			&template;
			exit;
		}
		else {
			# Check email
			&fatal_error("$txt{'76'}") if($FORM{'guest_email'} eq '');
			&fatal_error($txt{'243'}) if($FORM{'guest_email'} !~ /^[0-9A-Za-z@\._\-]+$/);
			&fatal_error("$txt{'500'}") if(($FORM{'guest_email'} =~ /(@.*@)|(\.\.)|(@\.)|(\.@)|(^\.)|(\.$)/) || ($FORM{'guest_email'} !~ /^.+@\[?(\w|[-.])+\.[a-zA-Z]{2,4}|[0-9]{1,4}\]?$/));

			# Not email-address of member ?
			fopen(FILE, "$memberdir/memberlist.txt");
			@memberlist = <FILE>;
			fclose(FILE);
			for ($a = 0; $a < @memberlist; $a++) {
				chomp $memberlist[$a];
				if( fopen(FILE2, "$memberdir/$memberlist[$a].dat") ) {

					# Load users and check email
					if( !$yyUDLoaded{$memberlist[$a]} && -e("$memberdir/$memberlist[$a].dat") ) {
						# If user is not in memory, s/he must be loaded.
						&LoadUser($memberlist[$a]);
						if($userprofile{$memberlist[$a]}->[2] eq $FORM{'guest_email'}) { &fatal_error("$notify_txt{'16'}"); }
					}
					fclose(FILE2);
				}
			}

			# Email-address OK !
			$settings[2] = $FORM{'guest_email'};
		}
	}
# --- /Added for Notify Plus 3.0 --- #

</replace>

<search for>
	$isonlist = 0;
	foreach $curmail (@mails) {
		$curmail =~ s/[\n\r]//g;
		if($settings[2] eq "$curmail") { $isonlist = 1; }
	}
</search for>

<replace>
# --- Deleted for Notify Plus 3.0 --- #
#	foreach $curmail (@mails) {
#		$curmail =~ s/[\n\r]//g;
#		if($settings[2] eq "$curmail") { $isonlist = 1; }
#	}
# --- /Deleted for Notify Plus 3.0 --- #

# --- Added for Notify Plus 3.0 --- #
	$isonlist = 0;
	foreach $record (@mails) {

		chomp($record);
		($email, $format) = split(/\|/, $record);
		chomp($email);
		if($settings[2] eq $email) { $isonlist = 1; }
	}
# --- /Added for Notify Plus 3.0 --- #

</replace>

<search for>
    $txt{'212'}<br>
    <b><a href="$cgi;action=notify3;thread=$INFO{'thread'};start=$INFO{'start'}">$txt{'163'}</a> - <a href="$cgi;action=display;num=$INFO{'thread'};start=$INFO{'start'}">$txt{'164'}</a></b>
</search for>

<replace>
<!--- Deleted for Notify Plus 3.0 --->
<!---     $txt{'212'}<br> --->
<!---     <b><a href="$cgi;action=notify3;thread=$INFO{'thread'};start=$INFO{'start'}">$txt{'163'}</a> - <a href="$cgi;action=display;num=$INFO{'thread'};start=$INFO{'start'}">$txt{'164'}</a></b> --->
<!--- /Deleted for Notify Plus 3.0 --->

<!--- Added for Notify Plus 3.0 --->
    $txt{'212'}<br>

    <b><a href="$cgi;action=notify3;thread=$INFO{'thread'};start=$INFO{'start'};guest_email=$FORM{'guest_email'}">$txt{'163'}</a> - <a href="$cgi;action=display;num=$INFO{'thread'};start=$INFO{'start'}">$txt{'164'}</a></b>
<!--- /Added for Notify Plus 3.0 --->

</replace>

<search for>
	if( $#mails eq 0) {
		unlink("$datadir/$thread.mail");
	} else
	# make no change with the file
	{
	fopen(FILE, ">$datadir/$thread.mail", 1) || &fatal_error("$txt{'23'} $thread.mail");
	print FILE "$settings[2]\n";
	foreach $curmail (@mails) {
		$curmail =~ s/[\n\r]//g;
		if($settings[2] ne $curmail) { print FILE "$curmail\n"; }
	}
	fclose(FILE);
	}
</search for>

<replace>
# --- Added for Notify Plus 3.0 --- #
	if( $#mails eq 0) {
		unlink("$datadir/$thread.mail");
	} else
	# make no change with the file
	{
	fopen(FILE, ">$datadir/$thread.mail", 1) || &fatal_error("$txt{'23'} $thread.mail");
	print FILE "$settings[2]\n";

	# When Guest
	if($username eq "Guest") {
		print FILE "$settings[2]|$FORM{'notifyformat'}\n";
	}
	# When Member
	else {
		print FILE "$settings[2]|$INFO{'username'}\n";
	}

	foreach $record (@mails) {

		chomp($record);
		($email, $format) = split(/\|/, $record);
		chomp($email);
		if($settings[2] ne $email) { print FILE "$record\n"; }
	}
# --- /Added for Notify Plus 3.0 --- #

</replace>

<search for>
	fopen(FILE, ">$datadir/$thread.mail", 1) || &fatal_error("$txt{'23'} $thread.mail");
	foreach $curmail (@mails) {
		$curmail =~ s/[\n\r]//g;
		if($settings[2] ne "$curmail") { print FILE "$curmail\n"; }
	}
</search for>

<replace>
# --- Deleted for Notify Plus 3.0 --- #
#	fopen(FILE, ">$datadir/$thread.mail", 1) || &fatal_error("$txt{'23'} $thread.mail");
#	foreach $curmail (@mails) {
#		$curmail =~ s/[\n\r]//g;
#		if($settings[2] ne "$curmail") { print FILE "$curmail\n"; }
#	}
# --- /Deleted for Notify Plus 3.0 --- #

# --- Added for Notify Plus 3.0 --- #
	fopen(FILE, ">$datadir/$thread.mail", 1) || &fatal_error("$txt{'23'} $thread.mail");
	foreach $record (@mails) {

		chomp($record);
		($email, $format) = split(/\|/, $record);
		chomp($email);
		if($settings[2] ne $email) { print FILE "$record\n"; }
	}
# --- /Added for Notify Plus 3.0 --- #

</replace>

<search for>
    $txt{'126'}<br>
    <b><a href="$cgi;action=notify2;thread=$INFO{'thread'};start=$INFO{'start'}">$txt{'163'}</a> - <a href="$cgi;action=display;num=$INFO{'thread'};start=$INFO{'start'}">$txt{'164'}</a></b>
</search for>

<replace>
<!--- Deleted for Notify Plus 3.0 --->
<!---    $txt{'126'}<br> --->
<!---    <b><a href="$cgi;action=notify2;thread=$INFO{'thread'};start=$INFO{'start'}">$txt{'163'}</a> - <a href="$cgi;action=display;num=$INFO{'thread'};start=$INFO{'start'}">$txt{'164'}</a></b> --->
<!--- /Deleted for Notify Plus 3.0 --->

<!--- Added for Notify Plus 3.0--->
	<form action="$cgi;action=notify2;thread=$INFO{'thread'};start=$INFO{'start'}" method="post" name="notifyForm">
	    $txt{'126'}<br>
		<input name="guest_email" type="hidden" value="$FORM{'guest_email'}">
~;

		# When Guest
		if($username eq "Guest") {

			$yymain .= qq~
			<font size=1>$notify_txt{'1'}</font>
			<input type="radio" name="notifyformat" value="HTML" checked><font size=1>$notify_txt{'2'}</font>
			<input type="radio" name="notifyformat" value="Plain"><font size=1>$notify_txt{'3'}</font><br>
~;
		}
		$yymain .= qq~
		<b><a href="javascript:document.notifyForm.submit();">$txt{'163'}</a> - <a href="javascript:history.go(-1)">$txt{'164'}</a></b>
	</form>
<!--- /Added for Notify Plus 3.0 --->

</replace>

<search for>
sub Notify2 {
	if( $currentboard eq '' ) { &fatal_error($txt{'1'}); }
	if($username eq 'Guest') { &fatal_error($txt{'138'}); }
</search for>

<replace>
# --- Deleted for Notify Plus 3.0 --- #
#sub Notify2 {
#	if( $currentboard eq '' ) { &fatal_error($txt{'1'}); }
#	if($username eq 'Guest') { &fatal_error($txt{'138'}); }
# --- /Deleted for Notify Plus 3.0 --- #

# --- Added for Notify Plus 3.0 --- #
sub Notify2 {
	if( $currentboard eq '' ) { &fatal_error($txt{'1'}); }

	# Get parameter 
	local($who) = @_;
	
	# When notify Guest: fill guest_email !
	if ($who eq 'Guest') { $FORM{'guest_email'} = $FORM{'email'}; }
	
	if($username eq 'Guest' && $enable_notification_guest == 0) { &fatal_error($txt{'138'}); }
	if($username eq 'Guest') { $settings[2] = $FORM{'guest_email'}; }
# --- /Added for Notify Plus 3.0 --- #

</replace>

<search for>
sub Notify3 {
	if( $currentboard eq '' ) { &fatal_error($txt{'1'}); }
	if($username eq "Guest") { &fatal_error("$txt{'138'}"); }
</search for>

<replace>
# --- Deleted for Notify Plus 3.0 --- #
#sub Notify3 {
#	if( $currentboard eq '' ) { &fatal_error($txt{'1'}); }
#	if($username eq "Guest") { &fatal_error("$txt{'138'}"); }
# --- /Deleted for Notify Plus 3.0 --- #

# --- Added for Notify Plus 3.0 --- #
sub Notify3 {
	if( $currentboard eq '' ) { &fatal_error($txt{'1'}); }
	if($username eq 'Guest' && $enable_notification_guest == 0) { &fatal_error($txt{'138'}); }
	if($username eq 'Guest') { $settings[2] = $INFO{'guest_email'}; }
# --- /Added for Notify Plus 3.0 --- #

</replace>

<search for>
sub Notify4 {
	if($username eq "Guest") { &fatal_error("$txt{'138'}"); }
</search for>

<replace>
# --- Deleted for Notify Plus 3.0 --- #
#sub Notify4 {
#	if($username eq "Guest") { &fatal_error("$txt{'138'}"); }
# --- /Deleted for Notify Plus 3.0 --- #

# --- Added for Notify Plus 3.0 --- #
sub Notify4 {
	if($username eq 'Guest' && $enable_notification_guest == 0) { &fatal_error("$txt{'138'}"); }
	if($username eq 'Guest') { $settings[2] = $FORM{'guest_email'}; }
# --- /Added for Notify Plus 3.0 --- #

</replace>

<search for>
		($dummy2,$threadno) = split(/-/,$variable);
		if ($dummy2 eq "thread") {

			fopen(FILE, "$datadir/$threadno.mail");
			@mails = <FILE>;
			fclose(FILE);


			# if there is only one entry and this is the address which is to remove, remove the file at all
			if( $#mails eq 0) {
				unlink("$datadir/$threadno.mail");
			} else
			# make no change with the file
			{
			fopen(FILE, ">$datadir/$threadno.mail") || &fatal_error("$txt{'23'} $threadno.mail");
			foreach $curmail (@mails) {
				$curmail =~ s/[\n\r]//g;
				if($settings[2] ne $curmail) { print FILE "$curmail\n"; }
			}
			fclose(FILE);
</search for>

<replace>
# --- Deleted for Notify Plus 3.0 --- #
#		($dummy2,$threadno) = split(/-/,$variable);
#		if ($dummy2 eq "thread") {
#
#			fopen(FILE, "$datadir/$threadno.mail");
#			@mails = <FILE>;
#			fclose(FILE);
#
#
#			# if there is only one entry and this is the address which is to remove, remove the file at all
#			if( $#mails eq 0) {
#				unlink("$datadir/$threadno.mail");
#			} else
#			# make no change with the file
#			{
#			fopen(FILE, ">$datadir/$threadno.mail") || &fatal_error("$txt{'23'} $threadno.mail");
#			foreach $curmail (@mails) {
#				$curmail =~ s/[\n\r]//g;
#				if($settings[2] ne $curmail) { print FILE "$curmail\n"; }
#			}
#			fclose(FILE);
# --- /Deleted for Notify Plus 3.0 --- #

# --- Added for Notify Plus 3.0 --- #
		($dummy2,$board_threadno) = split(/-/,$variable);

		# Board-level ?
		if ($dummy2 eq "board") {


			fopen(FILE, "$boardsdir/$board_threadno.mail");
			@mails = <FILE>;
			fclose(FILE);

			fopen(FILE, ">$boardsdir/$board_threadno.mail") || &fatal_error("$txt{'23'} $board_threadno.mail");
			foreach $record (@mails) {

				chomp($record);
				($email, $format) = split(/\|/, $record);
				chomp($email);
				if($settings[2] ne $email) { print FILE "$record\n"; }
			}
			fclose(FILE);
		}

		# Thread-level ?
		else {

			fopen(FILE, "$datadir/$board_threadno.mail");
			@mails = <FILE>;
			fclose(FILE);

			# if there is only one entry and this is the address which is to remove, remove the file at all
			if( $#mails eq 0) {
				unlink("$datadir/$threadno.mail");
			} else
			# make no change with the file
			{
			fopen(FILE, ">$datadir/$board_threadno.mail") || &fatal_error("$txt{'23'} $board_threadno.mail");
			foreach $record (@mails) {

				chomp($record);
				($email, $format) = split(/\|/, $record);
				chomp($email);
				if($settings[2] ne $email) { print FILE "$record\n"; }
			}
			fclose(FILE);

# --- /Added for Notify Plus 3.0 --- #

</replace>

<search for>
sub ShowNotifications {
	if($username eq "Guest") { &fatal_error("$txt{'138'}"); }
</search for>

<replace>
# --- Deleted for Notify Plus 3.0 --- #
# sub ShowNotifications {
# 	if($username eq "Guest") { &fatal_error("$txt{'138'}"); }
# --- /Deleted for Notify Plus 3.0 --- #

# --- Added for Notify Plus 3.0 --- #	
sub Notify5 {

	$settings[2] = $FORM{'guest_email'};
	my( $variable, $field, $threadno, @mails, $curmail );

	# Read all Formfields
	foreach $variable (keys %FORM) {

		($field,$threadno) = split(/-/,$variable);

		# When thread activated: Delete
		if ($field eq "thread") {

			fopen(FILE, "$datadir/$threadno.mail");
			@mails = <FILE>;
			fclose(FILE);
	
			fopen(FILE, ">$datadir/$threadno.mail") || &fatal_error("$txt{'23'} $threadno.mail");
			foreach $record (@mails) {
	
				chomp($record);
				($email, $format) = split(/\|/, $record);
				chomp($email);
				if($settings[2] ne $email) { print FILE "$record\n"; }
			}
			fclose(FILE);
		}
	}
	&ShowGuestNotification;
}

sub ShowNotifications {
	if ($username eq "Guest") {
	
		if ($FORM{'guest_email'} eq "") { 

			$yymain .= qq~
			<table border=0 width=100% cellspacing=1 bgcolor="$color{'bordercolor'}" class="bordercolor">
			<tr>
			    <td class="titlebg" bgcolor="$color{'titlebg'}">
					<font size=2 class="text1" color="$color{'titletext'}"><b>$txt{'125'}</b></font>
				</td>
			</tr>
			<tr>
		    	<td class="windowbg" bgcolor="$color{'windowbg'}">
					<font size=2>
					<form action="$cgi;action=shownotify" method="post" name="notifyForm">
						$notify_txt{'14'}
						<input type="text" name="guest_email" size="25" maxlength="30">
						<p>
						<b><a href="javascript:document.notifyForm.submit();">$notify_txt{'15'}</a> - <a href="javascript:history.go(-1)">$txt{'250'}</a></b>
					</form>
			    	</font>
				</td>
			</tr>
			</table>
~;

			$yytitle = "$txt{'125'}";
			&template;
			exit;
		}
		else {
			fopen(FILE, "$memberdir/memberlist.txt");
			@memberlist = <FILE>;
			fclose(FILE);
			for ($a = 0; $a < @memberlist; $a++) {
				chomp $memberlist[$a];
				if( fopen(FILE2, "$memberdir/$memberlist[$a].dat") ) {
		
					# Load users and check email
					if( !$yyUDLoaded{$memberlist[$a]} && -e("$memberdir/$memberlist[$a].dat") ) {
						# If user is not in memory, s/he must be loaded.
						&LoadUser($memberlist[$a]);
						if($userprofile{$memberlist[$a]}->[2] eq $FORM{'guest_email'}) { &fatal_error("$notify_txt{'16'}"); }
					}
					fclose(FILE2);
				}
			}	
			
			# Password is not from a Member	
			$settings[2] = $FORM{'guest_email'};
		}
	}
# --- /Added for Notify Plus 3.0 --- #
		
</replace>

<search for>
	# Load Censor List
	&LoadCensorList;
</search for>

<replace>
# --- Deleted for Notify Plus 3.0 --- #
#	# Load Censor List
#	&LoadCensorList;
# --- /Deleted for Notify Plus 3.0 --- #

</replace>

<search for>
	my(@dirdata,@datdata,$filename,$entry,@entries,$mnum,$dummy,$msub,$mname,$memail,$mdate,$musername,$micon,$mattach,$mip,$mmessage,@messages,@found_number,@found_subject,@found_date,@found_username);
</search for>

<add after>
# --- Added for Notify Plus 3.0 --- #

	my(@found_format);

	# Load Censor List
	&LoadCensorList;

	# Read required data for ALL members !
	&ReadAllMembers;

	# -----------------------------------------------------------------------------
	# BOARD-level
	# -----------------------------------------------------------------------------
	# Boardlevel is only for Members
	if($username ne "Guest") {

		# Read all .mail-Files and search for username
		opendir (DIRECTORY,"$boardsdir");
		@dirdata = readdir(DIRECTORY);
		closedir (DIRECTORY);
		@datdata = grep(/mail/,@dirdata);

		foreach $filename (@datdata) {

			fopen(FILE, "$boardsdir/$filename");
			@entries = <FILE>;
			fclose(FILE);

			foreach $record (@entries) {

				chomp($record);
				($email, $format) = split(/\|/, $record);

				chomp($email);
				if ($email eq $settings[2]) {

					# Read User Data
					$user_to_read =	$user_Array{"$email"};
					&ReadUserData($user_to_read);					

					# Push text from language-file !
					if ($user_format eq "HTML") { push(@found_boardformat,$notify_txt{'2'}); }
					elsif ($user_format eq "HTML-Attach") { push(@found_boardformat,$notify_txt{'45'}); }				
					else { push(@found_boardformat,$notify_txt{'3'}); }

					($boardid, $dummy) = split(/\./,$filename);
					fopen(FILE, "$boardsdir/$boardid.dat");
					@boarddata = <FILE>;
					fclose(FILE);

					push(@found_boardname,@boarddata[0]);
					push(@found_boardid,$boardid);
				}
			# End foreach record
			}
		# End foreach filename
		}
	# End if not Guest
	}
	# -----------------------------------------------------------------------------
	# THREAD-level
	# -----------------------------------------------------------------------------

# --- /Added for Notify Plus 3.0 --- #

</add after>

<search for>
	        foreach $entry (@entries) {
	        	$entry =~ s/[\n\r]//g;
	        	if ($entry eq $settings[2]) {
</search for>

<replace>
# --- Deleted for Notify Plus 3.0 --- #
#	        foreach $entry (@entries) {
#	        	$entry =~ s/[\n\r]//g;

#	        	if ($entry eq $settings[2]) {
# --- /Deleted for Notify Plus 3.0 --- #

# --- Added for Notify Plus 3.0 --- #
	        foreach $record (@entries) {

	        	chomp($record);
	        	($email, $format) = split(/\|/, $record);

	        	chomp($email);
	        	chomp($format);

	        	# When a Guest
	        	if ($username eq 'Guest') {
	        	   $user_format = $format;
	        	}
	        	# When a Member
	        	else {

	        	   # Read User Data
	        	   $user_to_read = $user_Array{"$email"};
	        	   &ReadUserData($user_to_read);					
	        	}

	        	if ($email eq $settings[2]) {

	        	   # Push text from Language-file
	        	   if ($user_format eq "HTML") { push(@found_format,$notify_txt{'2'}); }
	        	   elsif ($user_format eq "HTML-Attach") { push(@found_format,$notify_txt{'45'}); }
	        	   else { push(@found_format,$notify_txt{'3'}); }

# --- /Added for Notify Plus 3.0 --- #

</replace>

<search for>
	if (@found_number==0) {
		$yymain .= "$txt{'414'}<br><br>&nbsp;";
</search for>

<add before>
# --- Added for Notify Plus 3.0 --- #

	# -----------------------------------------------------------------------------
	# Show Notified Boards
	# -----------------------------------------------------------------------------
	# Only for Members !
	if ($username ne 'Guest') {

		# No Boards selected ?
		if (@found_boardname==0) {
			$yymain .= qq~ <font size=2><b>$notify_txt{'43'}</b></font><br>\n ~;
			$yymain .= qq~ $notify_txt{'42'}<br><br> ~;
		}
		else {
			$yymain .= qq~<form action="$cgi;action=notify4" method=post> ~;
			$yymain .= qq~ <input name="guest_email" type="hidden" value="$FORM{'guest_email'}"> ~;

			$yymain .= qq~ <table>\n ~;
			$yymain .= qq~ <tr><td colspan=2><font size=2><b>$notify_txt{'43'}</b></font></td></tr> ~;

			$counter=0;
			foreach $entry (@found_boardname) {
				$yymain .= qq~ <tr><td><font size=2> ~;
				$yymain .= qq~ <input type=checkbox name="board-$found_boardid[$counter]" value="1"></font></td> ~;
				$yymain .= qq~ <td><font size=2><b><i>$found_boardname[$counter]</i></b> </font></td></tr> ~;
				$yymain .= qq~ <tr><td></td> ~;
				$yymain .= qq~ <td><font size="1">$notify_txt{'1'} $found_boardformat[$counter]</font></td></tr> ~;

				$counter++;
			}

			$yymain .= qq~ </table>\n ~;
			$yymain .= qq~ <p>\n ~;
		}
	}
	# -----------------------------------------------------------------------------
	# Show Notified Threads
	# -----------------------------------------------------------------------------
	# No Threads selected ?
# --- /Added for Notify Plus 3.0 --- #

</add before>

<search for>
	if (@found_number==0) {
		$yymain .= "$txt{'414'}<br><br>&nbsp;";
	} else {
		foreach (@censored) {
		($tmpa,$tmpb) = @{$_};
		$found_subject[$counter] =~ s~\Q$tmpa\E~$tmpb~gi;
		}
		$yymain .= qq~<form action="$cgi;action=notify4" method=post>
<table>
  <tr>
      <td colspan=2><font size=2>$txt{'415'}:</font><br>&nbsp;</td></tr>
~;
		$counter=0;
		foreach $entry (@found_number) {
			&FormatUserName($found_username[$counter]);
			$yymain .= "<tr><td><font size=2>";
			$yymain .= qq~<input type=checkbox name="thread-$found_number[$counter]" value="1"></font></td>~;
			$yymain .= qq~<td><font size=2><b><i>$found_subject[$counter]</i></b> $txt{'525'} <a href="$scripturl?board=;action=viewprofile;username=$useraccount{$found_username[$counter]}">$found_name[$counter]</a></font></td></tr>\n~;
			$counter++;
		}
		$yymain .= "<tr><td colspan=2><br><font size=2>$txt{'416'}</font><br>&nbsp;</td></tr>\n";
		$yymain .= qq~<tr><td>&nbsp;</td><td><input type=reset value="$txt{'278'}">&nbsp;&nbsp;&nbsp;<input type=submit value="$txt{'417'}"></td></tr>~;
		$yymain .= "</table></form><br>&nbsp;\n";
	}
</search for>

<replace>
# --- Deleted for Notify Plus 3.0 --- #
#	if (@found_number==0) {
#		$yymain .= "$txt{'414'}<br><br>&nbsp;";
#	} else {
#		foreach (@censored) {
#		($tmpa,$tmpb) = @{$_};
#		$found_subject[$counter] =~ s~\Q$tmpa\E~$tmpb~gi;
#		}
#		$yymain .= qq~<form action="$cgi;action=notify4" method=post>
#<table>
#  <tr>
#      <td colspan=2><font size=2>$txt{'415'}:</font><br>&nbsp;</td></tr>
#~;
#		$counter=0;
#		foreach $entry (@found_number) {
#			&FormatUserName($found_username[$counter]);
#			$yymain .= "<tr><td><font size=2>";
#			$yymain .= qq~<input type=checkbox name="thread-$found_number[$counter]" value="1"></font></td>~;
#			$yymain .= qq~<td><font size=2><b><i>$found_subject[$counter]</i></b> $txt{'525'} <a href="$scripturl?board=;action=viewprofile;username=$useraccount{$found_username[$counter]}">$found_name[$counter]</a></font></td></tr>\n~;
#			$counter++;
#		}
#		$yymain .= "<tr><td colspan=2><br><font size=2>$txt{'416'}</font><br>&nbsp;</td></tr>\n";
#		$yymain .= qq~<tr><td>&nbsp;</td><td><input type=reset value="$txt{'278'}">&nbsp;&nbsp;&nbsp;<input type=submit value="$txt{'417'}"></td></tr>~;
#		$yymain .= "</table></form><br>&nbsp;\n";
#	}
# --- /Deleted for Notify Plus 3.0 --- #

# --- Added for Notify Plus 3.0 --- #

	if (@found_number==0) {
		$yymain .= qq~ <font size=2><b>$txt{'415'}:</b></font><br>\n ~;
		$yymain .= qq~ $txt{'414'}<br><br>&nbsp; ~;
	} else {
		foreach (@censored) {
		($tmpa,$tmpb) = @{$_};
		$found_subject[$counter] =~ s~\Q$tmpa\E~$tmpb~gi;
		}

		# Only when no boards with Notification
		if (@found_boardname==0 || $username eq "Guest") {
			$yymain .= qq~ <form action="$cgi;action=notify4" method=post> ~;
			$yymain .= qq~ <input name="guest_email" type="hidden" value="$FORM{'guest_email'}"> ~;
		}

		$yymain .= qq~ <table>\n ~;
		$yymain .= qq~ <tr><td colspan=2><font size=2><b>$txt{'415'}:</b></font></td></tr> ~;
		$counter=0;
		foreach $entry (@found_number) {
			&FormatUserName($found_username[$counter]);
			$yymain .= qq~ <tr><td><font size=2> ~;
			$yymain .= qq~ <input type=checkbox name="thread-$found_number[$counter]" value="1"></font></td> ~;
			$yymain .= qq~ <td><font size=2><b><i>$found_subject[$counter]</i></b> $txt{'525'} <a href="$scripturl?board=;action=viewprofile;username=$useraccount{$found_username[$counter]}">$found_name[$counter]</a></font></td></tr>\n ~;
			$yymain .= qq~ <td></td> ~;
			$yymain .= qq~ <td><font size="1">$notify_txt{'1'} $found_format[$counter]</font></td></tr> ~;

			$counter++;
		}
		$yymain .= qq~</table>\n ~;
	}


	# Show buttons when it gives a notification !
	if (@found_boardname != 0 || @found_number != 0) {
		$yymain .= qq~ <p>\n ~;

		$yymain .= qq~ <font size=2>$notify_txt{'44'}</font><br>&nbsp;\n ~;
		$yymain .= qq~ <br>\n ~;
		$yymain .= qq~ <input type=reset value="$txt{'278'}">&nbsp;&nbsp;&nbsp;<input type=submit value="$txt{'417'}"> ~;
	}

	$yymain .= qq~ </form><br>&nbsp;\n ~;

# --- /Added for Notify Plus 3.0 --- #

</replace>

<search for>
1;
</search for>

<add before>
# --- Added for Notify Plus 3.0 --- #

sub NotifyBoard {
	if( $currentboard eq '' ) { &fatal_error($txt{'1'}); }
	if($username eq 'Guest' && $enable_notification_guest == 0) { &fatal_error("$txt{'138'}"); }

	# When email of Guest not entered yet ...
	if($username eq "Guest") {

		if ($FORM{'guest_email'} eq "") {

			$yymain .= qq~
			<table border=0 width=100% cellspacing=1 bgcolor="$color{'bordercolor'}" class="bordercolor">
			<tr>
			    <td class="titlebg" bgcolor="$color{'titlebg'}">
					<font size=2 class="text1" color="$color{'titletext'}"><b>$txt{'125'}</b></font>
				</td>
			</tr>
			<tr>
		    	<td class="windowbg" bgcolor="$color{'windowbg'}">
					<font size=2>
					<form action="$cgi;action=notifyboard" method="post" name="notifyForm">
						$notify_txt{'14'}
						<input type="text" name="guest_email" size="25" maxlength="30">
						<br>
						<b><a href="javascript:document.notifyForm.submit();">$notify_txt{'15'}</a> - <a href="javascript:history.go(-1)">$txt{'250'}</a></b>

					</form>
			    	</font>
				</td>
			</tr>
			</table>
~;

			$yytitle = "$txt{'125'}";
			&template;
			exit;
		}
		else {
			# Check email
			&fatal_error("$txt{'76'}") if($FORM{'guest_email'} eq '');
			&fatal_error($txt{'243'}) if($FORM{'guest_email'} !~ /^[0-9A-Za-z@\._\-]+$/);
			&fatal_error("$txt{'500'}") if(($FORM{'guest_email'} =~ /(@.*@)|(\.\.)|(@\.)|(\.@)|(^\.)|(\.$)/) || ($FORM{'guest_email'} !~ /^.+@\[?(\w|[-.])+\.[a-zA-Z]{2,4}|[0-9]{1,4}\]?$/));

			# Not email-address of member ?
			fopen(FILE, "$memberdir/memberlist.txt");
			@memberlist = <FILE>;
			fclose(FILE);
			for ($a = 0; $a < @memberlist; $a++) {
				chomp $memberlist[$a];
				if( fopen(FILE2, "$memberdir/$memberlist[$a].dat") ) {

					# Load users and check email
					if( !$yyUDLoaded{$memberlist[$a]} && -e("$memberdir/$memberlist[$a].dat") ) {
						# If user is not in memory, s/he must be loaded.
						&LoadUser($memberlist[$a]);
						if($userprofile{$memberlist[$a]}->[2] eq $FORM{'guest_email'}) { &fatal_error("$notify_txt{'16'}"); }
					}
					fclose(FILE2);
				}
			}

			# Email-address OK !
			$settings[2] = $FORM{'guest_email'};
		}
	}

	# Check, if User already gets a notification
	@mails = ();
	if (-e("$boardsdir/$INFO{'board'}.mail")) {
		fopen(FILE, "$boardsdir/$INFO{'board'}.mail");
		@mails = <FILE>;
		fclose(FILE);
	}

	$isonlist = 0;

	foreach $record (@mails) {

		chomp($record);
		($email, $format) = split(/\|/, $record);
		chomp($email);
		if($settings[2] eq $email) { $isonlist = 1; }
	}

	if ($isonlist){

	$yymain .= qq~
<table border=0 width=100% cellspacing=1 bgcolor="$color{'bordercolor'}" class="bordercolor">
  <tr>
    <td class="titlebg" bgcolor="$color{'titlebg'}"><font size=2 class="text1" color="$color{'titletext'}"><b>$txt{'125'}</b></font></td>
  </tr><tr>
    <td class="windowbg" bgcolor="$color{'windowbg'}"><font size=2>
    $notify_txt{'40'}<br>
    <b><a href="$cgi;action=notifyboard3;guest_email=$FORM{'guest_email'}">$txt{'163'}</a> - <a href="$cgi">$txt{'164'}</a></b>
    </font></td>
  </tr>
</table>
~;


	} else
	{

	$yymain .= qq~
<table border=0 width=100% cellspacing=1 bgcolor="$color{'bordercolor'}" class="bordercolor">
  <tr>
    <td class="titlebg" bgcolor="$color{'titlebg'}"><font size=2 class="text1" color="$color{'titletext'}"><b>$txt{'125'}</b></font></td>
  </tr><tr>
    <td class="windowbg" bgcolor="$color{'windowbg'}"><font size=2>
	<form action="$cgi;action=notifyboard2" method="post" name="notifyForm">
	    $notify_txt{'41'}<br>
		<input name="guest_email" type="hidden" value="$FORM{'guest_email'}">
		<b><a href="javascript:document.notifyForm.submit();">$txt{'163'}</a> - <a href="javascript:history.go(-1)">$txt{'164'}</a></b>
	</form>
    </font></td>
  </tr>
</table>
~;

	}

	$yytitle = "$txt{'125'}";
	&template;
	exit;
}

sub NotifyBoard2 {
	if( $currentboard eq '' ) { &fatal_error($txt{'1'}); }

	if($username eq 'Guest' && $enable_notification_guest == 0) { &fatal_error($txt{'138'}); }
	if($username eq 'Guest') { $settings[2] = $FORM{'guest_email'}; }

	$board = $INFO{'board'};

	@mails = ();

	if (-e("$boardsdir/$board.mail")) {
		fopen(FILE, "$boardsdir/$board.mail");
		@mails = <FILE>;
		fclose(FILE);
	}
	fopen(FILE, ">$boardsdir/$board.mail", 1) || &fatal_error("$txt{'23'} $board.mail");

	print FILE "$settings[2]|$INFO{'username'}\n";

	foreach $record (@mails) {

		chomp($record);
		($email, $format) = split(/\|/, $record);
		chomp($email);
		if($settings[2] ne $email) { print FILE "$record\n"; }
	}

	fclose(FILE);
	$yySetLocation = qq~$cgi~;
	&redirectexit;
}

sub NotifyBoard3 {
	if( $currentboard eq '' ) { &fatal_error($txt{'1'}); }
	if($username eq 'Guest' && $enable_notification_guest == 0) { &fatal_error($txt{'138'}); }

	if($username eq 'Guest') { $settings[2] = $INFO{'guest_email'}; }

	$board = $INFO{'board'};
	fopen(FILE, "$boardsdir/$board.mail");
	@mails = <FILE>;
	fclose(FILE);
	fopen(FILE, ">$boardsdir/$board.mail", 1) || &fatal_error("$txt{'23'} $board.mail");

	foreach $record (@mails) {

		chomp($record);
		($email, $format) = split(/\|/, $record);
		chomp($email);
		if($settings[2] ne $email) { print FILE "$record\n"; }
	}

	fclose(FILE);
	$yySetLocation = qq~$cgi~;
	&redirectexit;
	}
}

# --- /Added for Notify Plus 3.0 --- #

</add before>

<edit file>
Sources/Post.pl
</edit file>

<search for>
$postplver = "1 Gold - SP 1.3";
</search for>

<add after>
# --- Added for Notify Plus 3.0 --- #
require "$sourcedir/NotifyPlus.pl";
# --- /Added for Notify Plus 3.0 --- #

</add after>

<search for>
    <input type=hidden name="postid" value="$postid">
</search for>

<add after>
<!--- Added for Notify Plus 3.0 --->
~;

# Add extra Fields when not Guest
if ($username ne 'Guest') {

	$yymain .= qq~
	<input type="hidden" name="name" value="$realname">
	<input type="hidden" name="email" value="$realemail">
~;

}

$yymain .= qq~
<!--- /Added for Notify Plus 3.0 --->

</add after>

<search for>
	$notification = ! $enable_notification || $username eq 'Guest' ? '' : <<"~;";
    <tr>
      <td class="windowbg"><font size=2><b>$txt{'131'}:</b></font></td>
      <td class="windowbg"><input type=checkbox name="notify" value="x"$notify> <font size="1">$txt{'750'}</font></td>
    </tr>
~;
</search for>

<replace>
# --- Deleted for Notify Plus 3.0 --- #
#	$notification = ! $enable_notification || $username eq 'Guest' ? '' : <<"~;";
#   <tr>
#      <td class="windowbg"><font size=2><b>$txt{'131'}:</b></font></td>
#     <td class="windowbg"><input type=checkbox name="notify" value="x"$notify> <font size="1">$txt{'750'}</font></td>
#   </tr>
#~;
# --- /Deleted for Notify Plus 3.0 --- #

# --- Added for Notify Plus 3.0 --- #
	# Notification enabled ?
	if ($enable_notification == 1) {

		# Notification enabled for guests ?
		if ($username ne 'Guest' || $enable_notification_guest == 1) {

			$notification = <<"~;";
    <tr>
      <td class="windowbg"><font size=2><b>$txt{'131'}:</b></font></td>
      <td class="windowbg"><font size=2><input type=checkbox name="notify" value="x"></font>
~;

			# When Guest
			if ($username eq 'Guest') {

				$notification .= <<"~;";

	<font size=1>$notify_txt{'1'}</font>
	<input type="radio" name="notifyformat" value="HTML" checked><font size=1>$notify_txt{'2'}</font>
	<input type="radio" name="notifyformat" value="Plain"><font size=1>$notify_txt{'3'}</font>
~;
			}
			# When Member
			else {

				$notification .= <<"~;";

	<font size=1>$txt{'750'}</font>
~;
			}

			$notification .= <<"~;";
	</td>
</tr>
~;
		}
	}
# --- /Added for Notify Plus 3.0 --- #

</replace>

<search for>
	# Notify any members who have notification turned on for this thread.
	if(-e("$datadir/$thread.mail")) { &NotifyUsers; }
</search for>

<replace>
# --- Deleted for Notify Plus 3.0 --- #
#	# Notify any members who have notification turned on for this thread.
#	if(-e("$datadir/$thread.mail")) { &NotifyUsers; }
# --- /Deleted for Notify Plus 3.0 --- #

# --- Added for Notify Plus 3.0 --- #
	# Notify any members who have notification turned on for this thread.
	if(-e("$datadir/$thread.mail")) { &NotifyUsers('thread'); }

	# Notify any members who have notification turned on for the board this thread is in.
	elsif ($enable_notification_board && -e("$boardsdir/$currentboard.mail")) {
		&NotifyUsers('board');
	}
# --- /Added for Notify Plus 3.0 --- #

</replace>

<search for>
	if($notify) {
		$INFO{'thread'} = $thread;
		$INFO{'start'} = $start;
		require "$sourcedir/Notify.pl";
		&Notify2;
	}
</search for>

<replace>
# --- Deleted for Notify Plus 3.0 --- #
#	if($notify) {
#		$INFO{'thread'} = $thread;
#		$INFO{'start'} = $start;
#		require "$sourcedir/Notify.pl";
#		&Notify2;
#	}
# --- /Deleted for Notify Plus 3.0 --- #

# --- Added for Notify Plus 3.0 --- #
	if( $notify ) {
		$INFO{'thread'} = $thread;
		$INFO{'start'} = $start;
		require "$sourcedir/Notify.pl";
		
		# When guest
		if ($username eq 'Guest') {
			&Notify2("Guest");
		}
		# When Member
		else {
			&Notify2();
		}
	}	
# --- /Added for Notify Plus 3.0 --- #

</replace>

<search for>
sub NotifyUsers {
</search for>

<add after>
# --- Added for Notify Plus 3.0 --- #

	# Type of posting
	local($post_type) = @_;
# --- /Added for Notify Plus 3.0 --- #

</add after>

<search for>
	fopen(FILE, "$datadir/$thread.mail") || return 0;
	@mails = <FILE>;
	fclose(FILE);
</search for>

<replace>
# --- Deleted for Notify Plus 3.0 --- #
#	fopen(FILE, "$datadir/$thread.mail") || return 0;
#	@mails = <FILE>;
#	fclose(FILE);
# --- /Deleted for Notify Plus 3.0 --- #

# --- Added for Notify Plus 3.0 --- #
	# Read Board-file
	@boardmails = ();
	if ($enable_notification_board && -e("$boardsdir/$currentboard.mail")) {
		fopen(FILE, "$boardsdir/$currentboard.mail") || return 0;
		@boardmails = <FILE>;
		fclose(FILE);
	}

	# Read Thread-file
	@threadmails = ();
	if(-e("$datadir/$thread.mail")) {
		fopen(FILE, "$datadir/$thread.mail") || return 0;
		@threadmails = <FILE>;
		fclose(FILE);
	}

	# Join both array's
	%usedemail = ();
	@mails = ();

	# Board-mails
	foreach $record (@boardmails) {

		chomp($record);
		($email, $format) = split(/\|/, $record);
		chomp($email);

		# Push email & format
		push(@mails, $record);

		# Save used email-address
		$usedemail{"$email"} = $email;
	}

	# Thread-mails
	foreach $record (@threadmails) {

		chomp($record);
		($email, $format) = split(/\|/, $record);
		chomp($email);

		if ($usedemail{"$email"} ne $email) {
			push(@mails, $record);
		}
	}
# --- /Added for Notify Plus 3.0 --- #

</replace>

<search for>
	foreach $curmail (@mails) {
		chomp $curmail;
		if ($curmail ne $settings[2]) {
			&sendmail($curmail,"$txt{'127'}\:  $subject","$txt{'128'}, $subject, $txt{'129'} $cgi;action=display;num=$thread\n\n$txt{'130'}");
		}
	}
</search for>

<replace>
# --- Deleted for Notify Plus 3.0  --- #
#	foreach $curmail (@mails) {
#		chomp $curmail;
#		if ($curmail ne $settings[2]) {
#			&sendmail($curmail,"$txt{'127'}\:  $subject","$txt{'128'}, $subject, $txt{'129'} $cgi;action=display;num=$thread\n\n$txt{'130'}");
#		}
#	}
# --- /Deleted for Notify Plus 3.0 --- #

# --- Added for Notify Plus 3.0 --- #
	# Send the topic

	&NP_SendTopic($post_type);
# --- /Added for Notify Plus 3.0 --- #

</replace>

<search for>
	# Update totals for this board.
	&doaddition;
</search for>

<add before>
# --- Added for Notify Plus 3.0 --- #
	# Write new Post for Mailinglist
	if ($enable_mailinglist == 1) {

		# Check if thread ID is already written in New posts File before
		$idfound = 0;
		fopen(FILE, "$vardir/newposts.txt");
		@newposts = <FILE>;
		fclose (FILE);

		foreach $newpost (@newposts) {

			chomp($newpost);
			local($board, $newpostid, $date) = split(/\|/, $newpost);
				if ($thread eq $newpostid) { $idfound =1; }
		}

		# Write thread ID in New posts File, when not written before
		if ($idfound == 0) {
			fopen(FILE, ">>$vardir/newposts.txt");
			print FILE "$currentboard|$thread|$date\n";
			fclose (FILE);
		}
	}
# --- /Added for Notify Plus 3.0 --- #

</add before>

<edit file>
Sources/Profile.pl
</edit file>

<search for>
$profileplver = "1 Gold - SP 1.3";
</search for>

<add after>
# --- Added for Notify Plus 3.0 --- #
require "$sourcedir/NotifyPlus.pl";
# --- /Added for Notify Plus 3.0 --- #

</add after>

<search for>
  </tr><tr>
    <td class="catbg" bgcolor="$color{'catbg'}" height="25"><font size=2><b>$txt{'597'}</b></font></td>
</search for>

<add before>
<!--- Added for Notify Plus 3.0 --->
  </tr>
~;

if ($enable_notification == 1 || $enable_mailinglist == 1) {

$yymain .= qq~
<tr>
    <td class="catbg" bgcolor="$color{'catbg'}" height="25"><font size=2><b>$notify_txt{'19'}</b></font></td>
  </tr>
~;
}


if ($enable_notification == 1 || $enable_mailinglist == 1) {

$yymain .= qq~
<tr>
    <td class="windowbg" bgcolor="$color{'windowbg'}"><font size=2>
    <table border=0 width="100%" cellpadding="3">
~;
	&ShowHTMLPrefs;

$yymain .= qq~
    </table><BR>
    </td>
 ~;
}

if ($enable_mailinglist == 1) {

$yymain .= qq~
<tr>
    <td class="windowbg" bgcolor="$color{'windowbg'}"><font size=2>
    <table border=0 width="100%" cellpadding="3">
~;

&ShowBoards;

$yymain .= qq~
    </table><BR>
    </td>
 ~;
}

$yymain .= qq~
<!--- /Added for Notify Plus 3.0 --->

</add before>

<search for>
		fopen( FILE, ">$memberdir/$member{'username'}.dat", 1);
</search for>

<add before>
# --- Added for Notify Plus 3.0 --- #
		fopen( FILE, ">$memberdir/$member{'username'}.da2", 1);
		print FILE "$FORM{'user_format'}\n";
		print FILE "$FORM{'user_includeimg'}\n";
		fclose(FILE);

# --- Added for Notify Plus 3.0 --- #

</add before>

<search for>
	if($newpassemail) {
</search for>

<add before>
# --- Added for Notify Plus 3.0 --- #

		if ($enable_mailinglist == 1) {

			# Update Malinglist
			&UpdateMailinglist;
		}

# --- Added for Notify Plus 3.0 --- #

</add before>

<search for>
		if($settings[7] eq 'Administrator') {
			unlink("$memberdir/$member{'username'}.dat");
			unlink("$memberdir/$member{'username'}.msg");
			unlink("$memberdir/$member{'username'}.log");
	                unlink("$memberdir/$member{'username'}.outbox");
	                unlink("$memberdir/$member{'username'}.imconfig");
</search for>

<add after>
# --- Added for Notify Plus 3.0 --- #
	               &RemoveMember_Mailinglist($member{'username'});
# --- /Added for Notify Plus 3.0 --- #

</add after>

<search for>
		elsif( $member{'username'} eq $username ) {
			unlink("$memberdir/$username.dat");
			unlink("$memberdir/$username.msg");
			unlink("$memberdir/$username.log");
	                unlink("$memberdir/$username.outbox");
	                unlink("$memberdir/$username.imconfig");
</search for>

<add after>
# --- Added for Notify Plus 3.0 --- #
	               &RemoveMember_Mailinglist($username);
# --- /Added for Notify Plus 3.0 --- #

</add after>

<edit file>
Sources/RemoveOldThreads.pl
</edit file>

<search for>
$removeoldthreadsplver = "1 Gold - SP 1.3";
</search for>

<add after>
# --- Added for Notify Plus 3.0 --- #
require "$sourcedir/NotifyPlus.pl";
# --- /Added for Notify Plus 3.0 --- #

</add after>

<search for>
					&Sticky_remove($num);
</search for>

<add after>
# --- Added for Notify Plus 3.0 --- #
					&RemoveThread_Mailinglist($num);
# --- /Added for Notify Plus 3.0 --- #

</add after>

<edit file>
Sources/RemoveThread.pl
</edit file>

<search for>
$removethreadplver = "1 Gold - SP 1.3";
</search for>

<add after>
# --- Added for Notify Plus 3.0 --- #
require "$sourcedir/NotifyPlus.pl";
# --- /Added for Notify Plus 3.0 --- #

</add after>

<search for>
	&Sticky_remove($thread);
</search for>

<add after>
# --- Added for Notify Plus 3.0 --- #
	&RemoveThread_Mailinglist($num);
# --- /Added for Notify Plus 3.0 --- #

</add after>

<edit file>
Sources/Sublist.pl
</edit file>

<search for>
'clean_log',"Admin.pl&clean_log",
</search for>

<add after>
# --- Added for Notify Plus 3.0 --- #
'deletefrommailinglist',"NotifyPlus.pl&DeleteFromMailinglist",
# --- /Added for Notify Plus 3.0 --- #

</add after>

<search for>
'sticky',"Subs.pl&Sticky",
</search for>

<add after>
# --- Added for Notify Plus 3.0 --- #
'sendmailinglist',"NotifyPlus.pl&SendMailinglist",
'sendmailinglist2',"NotifyPlus.pl&SendMailinglist2",
'showguestnotify',"NotifyPlus.pl&ShowGuestNotification",
# --- /Added for Notify Plus 3.0 --- #

</add after>

<search for>
'notify4',"Notify.pl&Notify4",
</search for>

<add after>
# --- Added for Notify Plus 3.0 --- #
'notify5',"Notify.pl&Notify5",
'notifyboard',"Notify.pl&NotifyBoard",
'notifyboard2',"Notify.pl&NotifyBoard2",
'notifyboard3',"Notify.pl&NotifyBoard3",
# --- /Added for Notify Plus 3.0 --- #

</add after>

<search for>
'usersrecentposts',"Profile.pl&usersrecentposts");
</search for>

<add before>
# --- Added for Notify Plus 3.0 --- #
'viewmailinglist',"NotifyPlus.pl&ViewMailinglist",
# --- /Added for Notify Plus 3.0 --- #

</add before>

<edit file>
Sources/Subs.pl
</edit file>

<search for>
	if($username eq 'Guest') { $yymenu .= qq~$menusep<a href="$scripturl?action=login">$img{'login'}</a>$menusep<a href="$cgi;action=register">$img{'register'}</a>~;
</search for>

<add after>
# --- Added for Notify Plus 3.0 --- #
	if ($username eq 'Guest' && $enable_notification_guest) {
		$yymenu .= qq~$menusep<a href="$scripturl?action=shownotify">$img{'notification'}</a>~;
	}
# --- /Added for Notify Plus 3.0 --- #

</add after>

<edit file>
Sources/YaBBC.pl
</edit file>

<search for>
sub MakeSmileys {
</search for>

<add after>
# --- Added for Notify Plus 3.0 --- #

local($parameter) = @_;

# Save & Change Image Directory
if ($parameter eq "IncludeImage") {
	$save_imagesdir = $imagesdir;
	$imagesdir = $imagesurl;
}

# --- /Added for Notify Plus 3.0 --- #


</add after>

<search for>
}

$MAXIMGWIDTH = 400;
$MAXIMGHEIGHT = 500;
</search for>

<add before>
# --- Added for Notify Plus 3.0 --- #

# Restore Image Directory
if ($parameter eq "IncludeImage") {
	$imagesdir = $save_imagesdir;
}
# --- /Added for Notify Plus 3.0 --- #

</add before>